<?php

namespace OCA\SensorLogger;


use OCP\IDBConnection;

class DataTypes {

	/**
	 * @param $userId
	 * @param IDBConnection $db
	 * @return array
	 */
	public static function getDataTypes($userId, IDBConnection $db) {
		$query = $db->getQueryBuilder();
		$query->select(array('id','description','type','short'))
			->from('sensorlogger_data_types')
			->where('user_id = "'.$userId.'"')
			->orderBy('id', 'DESC');
		$query->setMaxResults(100);
		$result = $query->execute();

		$data = $result->fetchAll();

		return $data;
	}

	/**
	 * @param $userId
	 * @param $dataTypeId
	 * @param IDBConnection $db
	 * @return DataType
	 */
	public static function getDataTypeById($userId, $dataTypeId, IDBConnection $db) {
		$query = $db->getQueryBuilder();
		$query->select(array('id','description','type','short'))
			->from('sensorlogger_data_types')
			->where('user_id = "'.$userId.'"')
			->andWhere('id = "'.$dataTypeId.'"');
		$query->setMaxResults(100);
		$result = $query->execute();

		$data = $result->fetch();
		
		if($data) {
			$data = DataType::fromRow($data);
		}

		return $data;
	}

	public static function getDeviceDataTypesByDeviceId($userId, $deviceId, IDBConnection $db) {
		$query = $db->getQueryBuilder();
		$query->select(array('sdt.id','sdt.description','sdt.type','sdt.short','sdt.type'))
			->from('sensorlogger_device_data_types','sddt')
			->leftJoin('sddt','sensorlogger_data_types','sdt', 'sdt.id = sddt.data_type_id')
			->where('sddt.user_id = "'.$userId.'"')
			->andWhere('sddt.device_id = "'.$deviceId.'" ')
			->orderBy('sddt.id', 'ASC');
		$query->setMaxResults(100);
		$result = $query->execute();

		$data = $result->fetchAll();

		return $data;
	}
}